package com.example.luodst;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.Button;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

public class MainActivity extends AppCompatActivity {
    private static String TAG = "XiaLuoHun";
    private Handler handler = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        initHandler();
        // 定位发送请求按钮
        Button btn = findViewById(R.id.mybtn);
        btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getResponse("http://www.baidu.com");
            }
        });
    }

    private void httpUrlConnection(String strUrl){
        try {
            URL url = new URL(strUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            //设置Http请求方法
            connection.setRequestMethod("GET");
            //设置请求参数
            connection.setRequestProperty("token","LuoHun");
            //设置连接超时时间
            connection.setConnectTimeout(8000);
            //设置接收超时时间
            connection.setReadTimeout(8000);
            // 开始连接
            connection.connect();
            //得到响应码
            //int responseCode = connection.getResponseCode();
 /*                       if(responseCode == HttpURLConnection.HTTP_OK){
                            //...
                        }*/
            //获取服务器返回的输入流
            InputStream in = connection.getInputStream();
            //if(in.available() > 0){

            // 每次写入1024字节
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize];
            StringBuffer sb = new StringBuffer();
            while ((in.read(buffer)) != -1) {
                sb.append(new String(buffer));
            }
            sendMsg(sb.toString());
            //Log.d("LuoHun", sb.toString());
            //关闭Http连接
            connection.disconnect();
            // }

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getResponse(String strUrl) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                httpUrlConnection(strUrl);
            }
        }).start();
    }

    private void initHandler() {
        handler = new Handler(getMainLooper(), new Handler.Callback() {
            @Override
            public boolean handleMessage(@NonNull Message msg) {
                if (msg.what == 1){
                    AlertDialog.Builder builder = new AlertDialog.Builder(MainActivity.this);
                    builder.setTitle("NOTICE");
                    builder.setMessage((String) msg.obj);
                    builder.setPositiveButton("Confirm",null);
                    builder.create().show();
                }
                return false;
            }
        });
    }

    private void sendMsg(String message){
        Message msg = new Message();
        msg.what = 1;
        msg.obj = message;
        handler.sendMessage(msg);
    }
}