#include <jni.h>
#include <string>
#include <stdio.h>
#include <dlfcn.h>

#include "mou.h"

typedef void (*FUNCTYPE)();

int main() {

    //动态使用
    void *handle = dlopen("/data/local/tmp/libmou.so", RTLD_LAZY);
    if (handle == NULL) {
        printf("dlopen:%s\n", dlerror());
    }

    //获取符号
    FUNCTYPE pfnMou1;
    pfnMou1 = (FUNCTYPE) dlsym(handle, "mou1");
    if (pfnMou1 == NULL) {
        printf("pfnMou1:%s\n", dlerror());
    } else {
        pfnMou1();
    }

    FUNCTYPE pfnMou2;
    pfnMou2 = (FUNCTYPE) dlsym(handle, "mou2");
    if (pfnMou2 == NULL) {
        printf("pfnMou1:%s\n", dlerror());
    } else {
        pfnMou2();
    }

    //地址反查
    Dl_info dlInfo;
    dladdr((void*)pfnMou2, &dlInfo);
    printf("dli_fname:%s dli_sname:%s\n", dlInfo.dli_fname, dlInfo.dli_sname);

    //卸载动态库
    dlclose(handle);

    printf("Hello Main\n");
    return 0;
}
