#include "LuoWidget.h"

#include <QToolBar>
#include <QStatusBar>

LuoWidget::LuoWidget(QWidget *parent)
	: QWidget(parent)
{
	ui.setupUi(this);

	//˵
	QMenuBar* m = new QMenuBar(this);
	//ͣ,̬˵
	connect(m, SIGNAL(hovered(QAction*)), this, SLOT(Hovered(QAction*)));

	//ò˵С
	m->resize(width(), m->height());
	//һ˵
	m1 = m->addMenu(QStringLiteral("˵1"));
	//QMenuӽڵ(ӽڵӽڵ),ᴥź
	connect(m1, SIGNAL(triggered(QAction*)), this, SLOT(Action(QAction*)));

	//˵
	QAction* a1 = m1->addAction(QStringLiteral("˵1.1"));
	//QAction ź
	connect(a1, SIGNAL(triggered()), this, SLOT(Action1()));
	//ͼ
	a1->setIcon(QIcon(":/LuoMenu/ke nan.png"));


	QAction* a2 = m1->addAction(QStringLiteral("˵1.2"));
	//QAction ͣź
	connect(a2, SIGNAL(hovered()), this, SLOT(Hover()));

	QAction* a3 = m1->addAction(QStringLiteral("˵1.3"));

	//ÿѡ
	a1->setCheckable(true);
	a2->setCheckable(true);
	a3->setCheckable(true);

	QActionGroup* ag = new QActionGroup(this);
	ag->addAction(a2);
	ag->addAction(a3);
	//ѡ
	ag->setExclusive(true);
	//Ƿѡ
	connect(a1, SIGNAL(triggered(bool)), this, SLOT(Action1(bool)));

	//ӿݼ
	a1->setShortcut(QString("A"));

	//˵
	QMenu* m14 = m1->addMenu(QStringLiteral("˵1.4"));
	m14->addAction(QStringLiteral("˵1.4.1"));
	//ͼ
	m14->setIcon(QIcon(":/LuoMenu/ke nan.png"));

	//һ˵
	QMenu* m2 = m->addMenu(QStringLiteral("˵2"));
	QMenu* m3 = m->addMenu(QStringLiteral("˵3"));

	//
	QToolBar* tBar = new QToolBar(this);
	tBar->setGeometry(0, m->height(), width(), 30);
	tBar->setIconSize(QSize(30, 30));
	tBar->addAction(a1);

	//״̬
	QStatusBar* sBar = new QStatusBar(this);
	sBar->setGeometry(0, height() - 30, width(), 30);
	sBar->showMessage(QStringLiteral("Ϣ3ʧ!"), 3000);
}

LuoWidget::~LuoWidget()
{
}
