#include "luoevent.h"

#include <QDebug>

LuoEvent::LuoEvent(QWidget *parent)
    : QWidget(parent)
{
    ui.setupUi(this);

    //
    //this->setMouseTracking(true);
}

bool LuoEvent::event(QEvent* ev)
{
	switch (ev->type())
	{
	case QEvent::KeyPress: {
		//¼
		//ƼkeyPressEventkeyReleaseEvent
		QKeyEvent* keyEv = (QKeyEvent*)ev;
		//жǷԶ
		if (!keyEv->isAutoRepeat())
		{
			//Ǵд
			qDebug() << (char)keyEv->key();
			//ִСд
			qDebug() << keyEv->text();

			if (keyEv->key() == 'A')
			{
				//trueʾѱ
				return true;
			}
		}
	}
	case QEvent::MouseButtonPress: {
		//¼
		QMouseEvent* me = (QMouseEvent*)ev;
		//()
		qDebug() << "QEvent::MouseButtonPress "
			<< QStringLiteral(" ")
			<< me->x()
			<< me->y();
		//򴰿
		qDebug() << "QEvent::MouseButtonPress "
			<< QStringLiteral("򴰿 ")
			<< me->windowPos().x()
			<< me->windowPos().y();
		//Ļ
		qDebug() << "QEvent::MouseButtonPress "
			<< QStringLiteral("Ļ ")
			<< me->screenPos().x()
			<< me->screenPos().y();

		//תĻ
		QPoint gPos = mapToGlobal(me->pos());
		qDebug() << "QEvent::MouseButtonPress "
			<< QStringLiteral("תĻ ")
			<< gPos.x()
			<< gPos.y();

		//ȡĻ
		qDebug() << "QCursor" << QCursor::pos().x() << QCursor::pos().y();

		//갴ť¼
		if (me->buttons() & Qt::LeftButton)
		{
			qDebug() << "LeftButton";

			//ͼ滻
			setCursor(Qt::ArrowCursor);
		}
		if (me->buttons() & Qt::RightButton)
		{
			qDebug() << "RightButton";
		}
		if (me->buttons() & Qt::MiddleButton)
		{
			qDebug() << "MiddleButton";
		}

		if (me->buttons() & Qt::LeftButton && me->buttons() & Qt::RightButton)
		{
			//ͼ滻
			QPixmap pix(":/LuoEvent/cursor.png");
			//-1, -1ʾȵλΪͼƬм
			//ȵλ,λ,
			//ͼƬܴ, -1, -1ʾȡͼƬмλΪĵλ
			QCursor cur = QCursor(pix, -1, -1);
			setCursor(cur);
		}

	}
	case QEvent::Resize: {
		//ڴСı¼
		QResizeEvent* re = (QResizeEvent*)ev;
		qDebug() << "Resize Old " << re->oldSize()
			<< "Resize New " << re->size();
	}
	default:
		break;
	}

	return QWidget::event(ev);
}

void LuoEvent::keyPressEvent(QKeyEvent* ev)
{
	//̰ĳ,Ӧ
	//̰ť,жǷԶ,򷵻
	if (ev->isAutoRepeat())
	{
		return;
	}

	qDebug() << "keyPressEvent " << ev->key();
}

void LuoEvent::keyReleaseEvent(QKeyEvent* ev)
{
	if (ev->isAutoRepeat())
	{
		return;
	}
	qDebug() << "keyReleaseEvent " << ev->key();
}

void LuoEvent::resizeEvent(QResizeEvent* re)
{
	qDebug() << "resizeEvent";

	//ڸıǰĴС
	//re->oldSize()
	//ڸıĴС
	//re->size()
}

