#include "luoqt.h"

#include <QTableWidget>
#include <QDebug>
#include <QIcon>
#include <QLabel>
#include <QPixmap>
#include <set>
#include <QMessageBox>
class LuoHeader :public QTableWidgetItem
{
public:
	LuoHeader::LuoHeader(QString qstr) : QTableWidgetItem(qstr)
	{
	}

	LuoHeader::~LuoHeader()
	{
		qDebug() << this->text() << "removed";
	}
};

luoqt::luoqt(QWidget* parent)
	: QWidget(parent)
{
	ui.setupUi(this);

	//б
	ui.tableWidget->setColumnCount(0);
	ui.tableWidget->setRowCount(0);

	//б
	ui.tableWidget->setColumnCount(5);
	//ʽ1
	ui.tableWidget->setHorizontalHeaderItem(0, new QTableWidgetItem("Col1"));
	//ʽ2
	ui.tableWidget->setHorizontalHeaderItem(1, new QTableWidgetItem);
	ui.tableWidget->horizontalHeaderItem(1)->setText("Col2");
	//ʽ3
	ui.tableWidget->setHorizontalHeaderItem(2, new LuoHeader("C3"));
	//ͬλò,֮ǰĶ,һ鿴̨,ͻᷢLuoHeaderᱻ
	ui.tableWidget->setHorizontalHeaderItem(2, new LuoHeader("Col2"));

	//ñеĿ
	ui.tableWidget->setColumnWidth(0, 200);

	//б
	ui.tableWidget->setRowCount(3);
	//÷ʽһ, ֻҪHorizontalVertical
	//չʾһֲһ淨
	QStringList qstrList = { "Row1", "Row2", "Row3" };
	ui.tableWidget->setVerticalHeaderLabels(qstrList);

	//
	int nRow = 0;
	int nCol = 0;
	// 35
	//00С01С02
	ui.tableWidget->setItem(0, 0, new QTableWidgetItem("Item 0, 0"));
	ui.tableWidget->setItem(0, 1, new QTableWidgetItem("Item 0, 1"));
	ui.tableWidget->setItem(0, 2, new QTableWidgetItem("Item 0, 2"));

	//βһ
    nRow = ui.tableWidget->rowCount();
	ui.tableWidget->insertRow(nRow);
	ui.tableWidget->setItem(nRow, 0, new QTableWidgetItem("ItemEnd"));

	//ʼһ
	ui.tableWidget->insertRow(0);
	ui.tableWidget->setItem(0, 0, new QTableWidgetItem("ItemBegin"));

	//QIconͼƬ
	nRow = 0;
	nCol = 1;
	ui.tableWidget->setItem(nRow, nCol, new QTableWidgetItem);
	ui.tableWidget->item(nRow, nCol)->setIcon(QIcon(":/luoqt/kenan.png"));
	//и
	ui.tableWidget->setRowHeight(nRow, 80);
	//ͼʾС
	ui.tableWidget->setIconSize(QSize(ui.tableWidget->rowHeight(nRow), ui.tableWidget->rowHeight(nRow)));

	//WidgetͼƬ
	nRow = 2;
	nCol = 0;
	QLabel* qLabel = new QLabel;
	QPixmap qPix(":/luoqt/kenan.png");
	//ŵͱԪĿһ
	qPix = qPix.scaled(ui.tableWidget->columnWidth(nCol), ui.tableWidget->rowHeight(nRow));
	qLabel->setPixmap(qPix);
	ui.tableWidget->setCellWidget(nRow, nCol, qLabel);

	//
	ui.tableWidget->insertRow(0);
	ui.tableWidget->insertRow(0);

	//ÿѡΪλ
	ui.tableWidget->setSelectionBehavior(QAbstractItemView::SelectRows);

	ui.tableWidget->setMouseTracking(true);

}

void luoqt::LuoClick()
{
	//ȡѡ
	//ʽһ
	//ַʽ,޷ѡ
	qDebug() << QStringLiteral("ʽһ--------------------------------");
	QList<QTableWidgetItem*> qTableItems = ui.tableWidget->selectedItems();
	for (int i = 0; i < qTableItems.size(); i++)
	{
		qDebug() << qTableItems[i]->row()
			<< ":"
			<< qTableItems[i]->column()
			<< " text="
			<< qTableItems[i]->text();
	}

	//ʽ2
	//ַʽ,ѡ
    qDebug() << QStringLiteral("ʽ--------------------------------");
	//ѡģʽ
	QItemSelectionModel* qItemSelModel = ui.tableWidget->selectionModel();
	//ȡеѡ
	QModelIndexList qModelIndexLst = qItemSelModel->selectedIndexes();
	//ȡбѡек
	std::set<int> stdRows;
	for (int i = 0; i < qModelIndexLst.size(); i++)
	{
		//ظĲʧ
		stdRows.insert(qModelIndexLst[i].row());
	}

	//ɾ
	//ûʾ
	QString qstrMsg = QStringLiteral("ȷɾ:");

	for (std::set<int>::iterator itr = stdRows.begin(); itr != stdRows.end(); itr++)
	{
		QTableWidgetItem* item = ui.tableWidget->item(*itr, 0);
		qstrMsg += "[";
		qstrMsg += QString::number(*itr + 1);
		qstrMsg += ":";
		if (item)
		{
			qstrMsg += item->text();
		}
		qstrMsg += "]";
	}

	int nRet = QMessageBox::information(this, "",
		qstrMsg, QStringLiteral("ȷ"),
		QStringLiteral("ȡ"));

	//ûȷϰť, nRet == 0
	//ûȡť, nRet == 1
	if (nRet == 0)
	{
		//ɾ
		while (true)
		{
			//ȡеѡ
			QModelIndexList s = qItemSelModel->selectedIndexes();
			if (s.size() <= 0)
			{
				break;
			}

			//ÿɾһ
			ui.tableWidget->removeRow(s[0].row());
		}
	}

}

void luoqt::SelChange()
{
	qDebug() << "SelChange";
}

void luoqt::ItemEntered(QTableWidgetItem* item)
{
	qDebug() << item->row() << " " << item->column();
}

void luoqt::CellEntered(int row, int column)
{
	//qDebug() << row << " " << column;
}
